//+------------------------------------------------------------------+
//|                                                       EA_WEB.mq5 |
//|                                                      Daniel Jose |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
#property description "Testing internal channel\nvia terminal global variable"
#property version "1.04"
//+------------------------------------------------------------------+
#include <Inner Channel.mqh>
//+------------------------------------------------------------------+
enum eWhat {DOW_JONES, SP500};
input eWhat	user01 = DOW_JONES;		//Buscar
//+------------------------------------------------------------------+
int OnInit()
{
	EventSetTimer(1);
	
	return INIT_SUCCEEDED;
}
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
	EventKillTimer();
}
//+------------------------------------------------------------------+
void OnTick()
{
}
//+------------------------------------------------------------------+
void OnTimer()
{
	ClientServer();
}
//+------------------------------------------------------------------+
inline void ClientServer(void)
{
	uDataServer loc1, loc2;
	string 		sz0;
	
	SetFind();
	if (GlobalVariableCheck(def_GlobalValueInChannel))
	{
		GlobalVariableGet(def_GlobalMaskInfo, loc1.value);
		loc2.value = GlobalVariableGet(def_GlobalValueInChannel);
		sz0 = CharArrayToString(loc2.Info, 0, sizeof(uDataServer));
		if (sz0 == def_MSG_FailedConnection) Print("Failed in connection."); else
		if (sz0 == def_MSG_FailedReturn) Print("Error in Server Web."); else
		if (sz0 == def_MSG_FailedMask) Print("Bad Mask or position."); else
		if (sz0 == def_MSG_FinishServer) Print("Service Stop."); else
		Print(CharArrayToString(loc1.Info, 0, sizeof(uDataServer)), "  ", loc2.value);
	}
}
//+------------------------------------------------------------------+
inline void SetFind(void)
{
	static int b = -1;
	uDataServer loc1, loc2;
	
	if ((GlobalVariableCheck(def_GlobalValueInChannel)) && (b != user01))
	{
		b = user01;
		switch (user01)
		{
			case DOW_JONES	:
				StringToCharArray("INDU:IND", loc1.Info, 0, sizeof(uDataServer));
				loc2.Position[0] = 172783;
				loc2.Position[1] = 173474;
				break;
			case SP500		:
				StringToCharArray("SPX:IND", loc1.Info, 0, sizeof(uDataServer));
				loc2.Position[0] = 175487;
				loc2.Position[1] = 176159;
				break;
		}
		GlobalVariableSet(def_GlobalMaskInfo, loc1.value);
		GlobalVariableSet(def_GlobalPositionInfos, loc2.value);
	}
};
//+------------------------------------------------------------------+
